import sys
sys.setrecursionlimit(300)

n = int(input())
nums = list(map(str, input().split()))

class Node:
    __slots__ = ("child", "nums")
    def __init__(self):
        self.child = {}
        self.nums = []

root = Node()

for s in nums:
    node = root
    for ch in s:
        if ch not in node.child:
            node.child[ch] = Node()
        node = node.child[ch]
    node.nums.append(s)

groups = []

def dfs(node, chain):
    chain = chain + node.nums
    if not node.child:
        groups.append(chain)
        return
    for nxt in node.child.values():
        dfs(nxt, chain)

dfs(root, [])

print(len(groups))
for g in groups:
    print(len(g))
    print(" ".join(g))